//
//  GSWindowControllerProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.03.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class GSFont;
@class GSLayer;
@protocol GlyphsTool;
@protocol GlyphsToolEvent;
@protocol GlyphsToolDraw;
@protocol GSGlyphEditViewControllerProtocol;

typedef NS_ENUM(NSUInteger, GSFontInfoTabIndex) {
	GSFontInfoTabIndexFont = 0,
	GSFontInfoTabIndexMasters = 1,
	GSFontInfoTabIndexExports = 2,
	GSFontInfoTabIndexFeatures = 3,
	GSFontInfoTabIndexDocument = 4,
	GSFontInfoTabIndexNotes = 5,
};

@protocol GSWindowControllerProtocol
/** The tool that is currently handling events
 */
@property (unsafe_unretained, nonatomic, nullable) NSResponder<GlyphsTool, GlyphsToolDraw> *toolDrawDelegate;
@property (unsafe_unretained, nonatomic, nullable) NSResponder<GlyphsTool, GlyphsToolEvent> *toolEventDelegate;
@property (readonly, nonatomic, nullable) NSResponder<GlyphsTool, GlyphsToolEvent> *toolEventDelegateSelected;
@property (readonly, nonatomic, nullable) NSResponder<GlyphsTool, GlyphsToolEvent> *toolTempSelection;
@property (retain, nonatomic, nullable) NSArray *toolInstances;

/// if the Shift key is currently pressed
@property (nonatomic) bool ShiftKey;
/// if the alt/option key is currently pressed
@property (nonatomic) bool AltKey;
/// if the Ctrl key is currently pressed
@property (nonatomic) bool CtrlKey;
/// if the Command key is currently pressed
@property (nonatomic) bool CommandKey;
/// if the Space key is currently pressed
@property (nonatomic) bool SpaceKey;

/** The index of the tool that was active before the current.

 @see selectedToolIndex
 */
@property (nonatomic) NSUInteger lastSelectToolIndex;

/** The index of the currently active tool
 @see lastSelectToolIndex
 */
@property (nonatomic) NSUInteger selectedToolIndex;
@property (unsafe_unretained, nonatomic) IBOutlet NSArrayController *glyphListController;

/// Convenience getter for self.glyphsDocument.font.
@property (nonatomic, readonly) GSFont *documentFont;

/** the currently active layer of the window

 This is only valid if one layer has direct focus. If more than one are selected, this returns nil.

 @return the active layer.
 */
@property (unsafe_unretained, readonly, nullable) GSLayer *activeLayer;

- (NSArray *)selectedLayers;

- (NSArray *)allLayers;

/** The active editView controller or nil if the font view is active

 @return the active edit view controller
 */

@property (unsafe_unretained, readonly, nonatomic, nullable) NSViewController<GSGlyphEditViewControllerProtocol> *activeEditViewController;

/** The index of the active master

 @return The index of the active master
 */
@property (nonatomic) NSUInteger masterIndex;

/** The activate a tool based on its class

 @param aClass the class of the tool that should be activated.
 */
- (void)setToolForClass:(Class)aClass;

#ifndef GLYPHS_LITE
- (void)showGlyphInFontView:(GSGlyph *)glyph;

- (void)showTabAtIndex:(NSInteger)idx;

- (id)viewControllerAtIndex:(NSInteger)idx;

/** Show the font info window

 @param tabIdx the index of the tab that should be activated
 */

- (nullable NSViewController *)showFontInfoWindowWithTabSelected:(GSFontInfoTabIndex)tabIdx;

- (nullable NSViewController<GSGlyphEditViewControllerProtocol> *)addTabWithDisplayString:(nonnull NSString *)displayString;

- (nullable NSViewController<GSGlyphEditViewControllerProtocol> *)addTabWithString:(nonnull NSString *)string;
#endif

- (nullable NSViewController<GSGlyphEditViewControllerProtocol> *)addTabWithLayers:(nonnull NSArray<GSLayer *> *)layers;

- (nullable NSViewController<GSGlyphEditViewControllerProtocol> *)addTabWithGlyphs:(nonnull NSArray<GSGlyph *> *)glyphs;

@end
NS_ASSUME_NONNULL_END
